<?php
defined('ARI_FRAMEWORK_LOADED') or die('Direct Access to this location is not allowed.');

AriKernel::import('Flickr.Flickr');

class AriFlickrProvider extends AriObject
{
	var $_cacheDir;
	var $_flickr;
	
	function __construct($params, $cacheDir = null, $ext = null)
	{
		if (is_null($cacheDir))
		{ 
			$cacheDir = JPATH_ROOT . DS . 'cache';
			if (!is_null($ext))
			{
				$extCacheDir = $cacheDir . DS . $ext;
			
				if (file_exists($extCacheDir) && is_dir($extCacheDir))
					$cacheDir = $extCacheDir;
			}
		}
		
		$this->_cacheDir = $cacheDir;
		
		$apiKey = $params['apikey'];
		$cachePeriod = @intval($params['cachePeriod'], 10);
		$flickr = new phpFlickr($apiKey);
		if ($cachePeriod > 0 && $this->_cacheDir)
			$flickr->enableCache('fs', $this->_cacheDir, $cachePeriod);

		$this->_flickr =& $flickr;
	}
	
	function getData($params)
	{
		$data = array();
		$src = AriUtils2::getParam($params, 'source');
		switch ($src)
		{
			case 'photoset':
				$photosetIds = explode(';', $params['pssource']['photosetId']);
				$data = $this->getPhotosetsData($photosetIds, $params);
				break;

			case 'user':
				$userIds = explode(';', $params['usersource']['userId']);
				$data = $this->getUsersData($userIds, $params);
				break;
		}

		return $data;
	}
	
	function getUsersData($userIds, $params)
	{
		$data = array();
		$flickr =& $this->_flickr;
		$photosets = array();
		$photosetsData = array();

		foreach ($userIds as $userId)
		{
			if (empty($userId))
				continue ;
				
			$flickrPhotosets = $flickr->photosets_getList($userId);
			if (!empty($flickrPhotosets['photoset']))
			{
				foreach ($flickrPhotosets['photoset'] as $photoset)
				{
					$photosetId = $photoset['id'];
					$photosets[] = $photoset['id'];
					$photosetsData[$photosetId] = $photoset;
				}
			}
		}
		
		if (count($photosets) > 0)
			$data = $this->getPhotosetsData($photosets, $params, $photosetsData);

		return $data;
	}
	
	function getPhotosetsData($photosetIds, $params, $photosets = null)
	{
		$data = array('photos' => array(), 'photosets' => array());
		$photos = array();
		$flickr =& $this->_flickr;

		$count = intval($params['count'], 10);
		if ($count < 1) $count = null;
		foreach ($photosetIds as $photosetId)
		{
			if (empty($photosetId))
				continue ;

			$flickrPhotoset = $flickr->photosets_getPhotos($photosetId, 'date_upload,last_update', null, $count);
			
			$photosetData = $this->getPhotosetData($flickrPhotoset, $params);
			if (!empty($photosetData))
				$photos = array_merge($photos, $photosetData);
				
			$data['photosets'][$photosetId] = isset($photosets[$photosetId])
				? $photosets[$photosetId]
				: $flickr->photosets_getInfo($photosetId);
		}
		
		$data['photos'] = $photos;

		return $data;
	}
	
	function getPhotosetData($photoset, $params)
	{
		$data = array();
		if (empty($photoset))
			return $data;
		
		$photos = null;
		$photoset = AriUtils2::getParam($photoset, 'photoset', $photoset);
		if ($photoset) $photos = AriUtils2::getParam($photoset, 'photo');
		if (empty($photos))
			return $data;

		$photosetId = $photoset['id'];
		$thumbSize = AriUtils2::getParam($params, 'thumbSize', 'thumbnail');
		$imgSize = $params['imgSize'];

		foreach ($photos as $photo)
		{
			$thumbUrl = @phpFlickr::buildPhotoURL($photo, $thumbSize);
			$title = str_replace('"', '&quot;', AriUtils2::getParam($photo, 'title', ''));

			$data[$photo['id']] = array(
				'photosetId' => $photosetId,
				'dateUpload' => AriUtils2::getParam($photo, 'dateupload'),
				'lastUpdate' => AriUtils2::getParam($photo, 'lastupdate'),
				'imgUrl' => @phpFlickr::buildPhotoURL($photo, $imgSize),
				'thumbUrl' => @phpFlickr::buildPhotoURL($photo, $thumbSize),
				'Title' => $title
			);
		}

		return $data;
	}
}
?>