<?php
/*
 * ARI Sexy Lightbox
 *
 * @package		ARI Sexy Lightbox
 * @version		1.0.0
 * @author		ARI Soft
 * @copyright	Copyright (c) 2010 www.ari-soft.com. All rights reserved
 * @license		GNU/GPL (http://www.gnu.org/copyleft/gpl.html)
 * 
 */

defined('ARI_FRAMEWORK_LOADED') or die('Direct Access to this location is not allowed.');

AriKernel::import('Module.Providers.ThumbnailProvider');
AriKernel::import('Module.Lightbox.Models.GalleryModel');
AriKernel::import('SexyLightbox.Models.Templates.SimpleGalleryTemplate');

class AriSexyLightboxImglistModel extends AriGalleryModel
{
	var $_prefix = 'AriSexyLightbox';

	function execute($modelParams, $params, $templatePath)
	{
		$thumbProvider = new AriThumbnailProvider('arithumb', null, 'mod_arisexylightbox');
		$data = $thumbProvider->getStoredData($this->getThumbProviderParams($modelParams, $params));
		
		$this->modifyData($data, $params);
		
		if ($modelParams['type'] == 'customtext')
		{
			$cId = uniqid('asb_', false);
			$modelParams['customtemplate'] = '<div id="' . $cId . '" style="cursor: pointer;">' . $modelParams['customtemplate'] . '</div>';
			$document =& JFactory::getDocument();
			$document->addScriptDeclaration(sprintf('jQuery(document).ready(function($){ $("#%1$s").click(function(event) { $("#%1$s").closest(".ari_lightbox_container").find("a[rel^=\'sexylightbox\']").eq(0).click(); }); });',
				$cId));			
		}

		parent::execute(
			$data, 
			array(
				'simpleGallery' => ASEXYBOX_SIMPLEGALLERYTEMPLATE,
				'singleGallery' => ASEXYBOX_SINGLEIMAGEGALLERYTEMPLATE,
				'hiddenItems' => ASEXYBOX_HIDDENITEMSTEMPLATE),
			$modelParams,
			$params,
			$templatePath);
	}
	
	function getThumbProviderParams($modelParams, $params)
	{
		$thumbProviderParams = $modelParams;
		$thumbProviderParams['key'] = $params['_default']['key'];
		$thumbProviderParams['checkSum'] = $params['_default']['checkSum'];
		
		return $thumbProviderParams;
	}

	function modifyData(&$data, $params)
	{
		$rootUri = JURI::root(true) . '/';
		$group = $params['_default']['groupName'];
		if (empty($group)) $group = uniqid('asexy_');
		$modal = AriUtils2::parseValueBySample($params['_default']['modal'], false);
		foreach ($data as $key => $value)
		{
			$dataItem =& $data[$key];
			
			$img = $dataItem['image'];
			$title = str_replace('"', '&qout;', AriUtils2::getParam($dataItem, 'Title', ''));
			$aAttrs = array('href' => $rootUri . $img . ($modal ? '?modal=1' : ''), 'rel' => 'sexylightbox[' . $group . ']', 'title' => $title);
			$imgAttrs = array('src' => $rootUri . $dataItem['thumb'], 'border' => '0', 'alt' => $title);
			if ($dataItem['w']) $imgAttrs['width'] = $dataItem['w'];
			if ($dataItem['h']) $imgAttrs['height'] = $dataItem['h'];
			$dataItem['sexyimage'] = sprintf('<a%1$s><img%2$s/></a>',
				AriHtmlHelper::getAttrStr($aAttrs),
				AriHtmlHelper::getAttrStr($imgAttrs));
		}
	}	
}
?>