<?php
defined('ARI_FRAMEWORK_LOADED') or die('Direct Access to this location is not allowed.');

AriKernel::import('Module.Model');
AriKernel::import('Web.Controls.Repeater');
AriKernel::import('Utils.Utils');

class AriGalleryModel extends AriModuleModelBase
{
	function execute($data, $rptTemplates, $modelParams, $params, $templatePath)
	{
		$rptTemplate = '';
		$templatePath = dirname(__FILE__) . DS . 'templates' . DS . 'gallery' . DS;
		$invisibleData = null;
		switch ($modelParams['type'])
		{
			case 'gallery':
				$templateParams = $modelParams['simplegallery'];
				$visibleItemCount = intval(AriUtils::getParam($templateParams, 'visibleItemCount', 0), 10);
				if ($visibleItemCount > 0)
				{
					$data = array_values($data);
					$invisibleData = array_slice($data, $visibleItemCount);
					$data = array_slice($data, 0, $visibleItemCount);
				}
				
				$id = uniqid('sg_', false);
				$templateParams['id'] = $id;

				$cssStyles = '';
				$templateParams['GalleryCaption'] = !isset($templateParams['showTitle']) || AriUtils::parseValueBySample($templateParams['showTitle'], false) 
					? '{$data:Title}'
					: '';
				
				if (isset($templateParams['showTitle']) && empty($templateParams['showTitle']))
				{
					$cssStyles .= '#' . $id . ' .afancybox-title{display:none;}';
				}

				$document =& JFactory::getDocument();
				if ($cssStyles)
				{
					$document->addStyleDeclaration($cssStyles);
				}

				$rptTemplate = AriSimpleTemplate::parse(
					AriUtils2::getParam($rptTemplates, 'simpleGallery'), 
					$templateParams);
				break;
				
			case 'advgallery':
				$rptTemplate = $modelParams['advgallerytemplate'];
				break;
				
			case 'singleimage':
				$rptTemplate = AriUtils2::getParam($rptTemplates, 'singleGallery');
				break;
				
			case 'customtext':
				$rptTemplate = AriUtils2::getParam($rptTemplates, 'singleGallery');
				break;
		}

		if ($modelParams['type'] == 'singleimage')
		{
			$template = $modelParams['singletemplate'];
			$firstDataItem = array_shift($data);

			$repeater = new AriRepeaterWebControl($rptTemplate, $data);
			AriTemplate::display(
				$templatePath . 'singleimage.html.php', 
				array('repeater' => $repeater, 'firstImage' => AriSimpleTemplate::parse($template, array('data' => $firstDataItem))));
		}
		else if ($modelParams['type'] == 'customtext')
		{
			$repeater = new AriRepeaterWebControl($rptTemplate, $data);
			AriTemplate::display(
				$templatePath . 'customtext.html.php', 
				array('repeater' => $repeater, 'template' => $modelParams['customtemplate']));
		}
		else 
		{
			$repeater = new AriRepeaterWebControl($rptTemplate, $data);
			AriTemplate::display(
				$templatePath . 'gallery.html.php', 
				array('repeater' => $repeater));
		}
		
		if ($invisibleData)
		{
			$repeater = new AriRepeaterWebControl(AriUtils2::getParam($rptTemplates, 'hiddenItems'), $invisibleData);
			$repeater->render();
		}
	}
}
?>