<?php
/*
 * ARI Sexy Lightbox
 *
 * @package		ARI Sexy Lightbox
 * @version		1.0.0
 * @author		ARI Soft
 * @copyright	Copyright (c) 2010 www.ari-soft.com. All rights reserved
 * @license		GNU/GPL (http://www.gnu.org/copyleft/gpl.html)
 * 
 */

defined('ARI_FRAMEWORK_LOADED') or die('Direct Access to this location is not allowed.');

AriKernel::import('Utils.Utils2');
AriKernel::import('Document.DocumentHelper');
jimport('joomla.filter.filterinput');

class AriSexyLightboxHelper
{
	function includeAssets($loadJQuery, $noConflict, $options = array())
	{
		static $loaded;

		if ($loaded)
			return ;

		$baseUri = JURI::root(true) . '/modules/mod_arisexylightbox/includes/js/';
		if ($loadJQuery) 
		{
			AriDocumentHelper::includeJsFile('http://ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js');
			
			if ($noConflict)
			{
				AriDocumentHelper::includeJsFile($baseUri . 'jquery.noconflict.js');
			}
		}
			
		AriDocumentHelper::includeJsFile($baseUri . 'jquery.easing.js');
		AriDocumentHelper::includeJsFile($baseUri . 'jquery.sexylightbox.min.js');
		AriDocumentHelper::includeCssFile($baseUri . 'sexylightbox.css');

		$jsOptions = AriSexyLightboxHelper::getJsOptions($options);
		$document =& JFactory::getDocument();
		$document->addScriptDeclaration(sprintf('jQuery(document).ready(function(){ SexyLightbox.initialize(%s); });',
			!empty($jsOptions) ? AriJSONHelper::encode($jsOptions) : ''));
			
		$loaded = true;
	}
	
	function activateAutoShow($group = '', $autoShow = true, $uniqueKey = false)
	{
		if ($autoShow != 'first')
			$autoShow = AriUtils2::parseValueBySample($autoShow, false);
		
		if (!$autoShow)
			return ;
			
		static $loaded;
		
		if ($loaded)
			return ;

		if ('first' === $autoShow && !empty($uniqueKey))
		{
			$cookieKey = 'asl_' . $uniqueKey;
			if (!empty($_COOKIE[$cookieKey]))
				return ;
			
			setcookie($cookieKey, '1', time() + 365 * 24 * 60 * 60);
		}
		
		$document =& JFactory::getDocument();
		$document->addScriptDeclaration(sprintf('jQuery(document).ready(function($){ $("a[rel^=\'%1$s\']").eq(0).click(); });',
			$group 
				? 'sexylightbox[' . $group . ']'
				: 'sexylightbox'));
		
		$loaded = true;
	}
	
	function getJsOptions($overrideOptions = array())
	{
		$defOptions = array(
			'enableShow' => false,
			'pauseDuration' => 5000,
			'autoStart' => false,
			'find' => 'sexylightbox',
			'zIndex' => 32000,
			'color' => 'black',
			'emergefrom' => 'top',
			'showDuration' => 200,
			'closeDuration' => 400,
			'moveDuration' => 1000,
			'moveEffect' => 'easeInOutBack',
			'resizeDuration' => 1000,
			'resizeEffect' => 'easeInOutBack',
			'shake' => array(
				'distance' => 10,
                'duration' => 100,
                'loops' => 2,
                'transition' => 'easeInOutBack'
            )
		);

		$jsOptions = AriParametersHelper::getUniqueOverrideParameters($defOptions, $overrideOptions);
		$jsOptions['dir'] = JURI::root(true) . '/modules/mod_arisexylightbox/includes/js/sexyimages';
		
		if (!empty($overrideOptions['overlayStyle']))
		{
			$fixOverlayStyle = array();
			$overlayStyle = $overrideOptions['overlayStyle'];
			foreach ($overlayStyle as $key => $value)
			{
				if (!is_null($value) && strlen($value) > 0)
					$fixOverlayStyle[$key] = $value;
			}
			
			$jsOptions['overlayStyle'] = $fixOverlayStyle;
		}

		return $jsOptions;
	}
	
	function executeModel($model, $params, $templatePath)
	{
		$modelParams = isset($params[$model]) ? $params[$model] : null;
		$model = ucfirst(JFilterInput::clean($model, 'WORD'));
		if (empty($model))
		{
			AriSexyLightboxHelper::executeErrorModel($params, $templatePath);
			return ;
		}
		else
		{
			$modelName = 'SexyLightbox' . $model . 'Model';
			$modelPath = dirname(__FILE__) . DS . 'Models' . DS . 'class.' . $modelName . '.php';

			if (!@file_exists($modelPath))
			{
				AriSexyLightboxHelper::executeErrorModel($params, $templatePath);
				return ;
			}
			else
			{
				AriKernel::import('SexyLightbox.Models.' . $modelName);

				$modelClass = 'Ari' . $modelName;
				$oModel = new $modelClass();
				$oModel->execute($modelParams, $params, $templatePath);
			}
		}
	}
	
	function executeErrorModel($params, $templatePath)
	{
		AriKernel::import('SexyLightbox.Models.SexyLightboxErrorModel');
		
		$errorModel = new AriSexyLightboxErrorModel();
		$errorModel->execute(null, $params, $templatePath);
	}
}
?>