<?php
/*
All Rights Reserved.	

No use, copying or distribution of this work may be made except in accordance with a valid license agreement from Artetics. 
This notice must be included on all copies, modifications and derivatives of this work. Artetics products are provided "as is" without warranty of any kind, 
either expressed or implied. In no event shall our juridical person be liable for any damages including, but not limited to, direct, indirect, special, incidental or 
consequential damages or other losses arising out of the use of or inability to use our products.

Customer may not sub-license, assign, or transfer this license to anyone else without prior written consent from Artetics.

All files and subfolders in this folder are provided under the license mentioned above with exception for files that contain license notes themselves.

Copyright (c) 2009 Artetics, artetics.com
*/

error_reporting(E_ERROR);
require_once(JPATH_SITE . DS . 'modules' . DS . 'mod_artsexylightbox' . DS . 'artsexylightbox' . DS . 'library' . DS . 'json.php');
require_once(JPATH_SITE . DS . 'modules' . DS . 'mod_artsexylightbox' . DS . 'artsexylightbox' . DS . 'library' . DS . 'asido' . DS . 'class.asido.php');

if (!function_exists('aslMisImage')) {
	/** Check whether file is an image **/
	function aslMisImage($fileName) {
		$extensions = array('.jpeg', '.jpg', '.gif', '.png', '.bmp', '.tiff', '.tif', '.ico', '.rle', '.dib', '.pct', '.pict');
		$extension = substr($fileName, strrpos($fileName,"."));
		if (in_array(strtolower($extension), $extensions)) return true;
		return false;
	}
}
if (!function_exists('aslMisExtensionsLoaded')) {
	/** Check whether Asido extension is loaded **/
	function aslMisExtensionsLoaded($drivers = array('imagick', 'gd', 'magickwand')) {
		reset($drivers);

		foreach ($drivers as $driver) {
			if ($driver == 'imagick' && !function_exists('imagick_readImage')) continue;
			
			if (@extension_loaded($driver)) {
				return true;
			}
		}
		
		return false;
	}
}
if (!function_exists('aslMloadExtensions')) {
	/** Load Asido extensions **/
	function aslMloadExtensions($drivers = array('imagick', 'gd', 'magickwand')) {
		$driverAliases = array('imagick' => 'imagick_ext', 'magickwand' => 'magick_wand');
		reset($drivers);
		foreach ($drivers as $driver) {
			if (@extension_loaded($driver)) {
				if ($driver == 'imagick' && !function_exists('imagick_readImage')) continue ;
				
				if (array_key_exists($driver, $driverAliases)) $driver = $driverAliases[$driver];
				asido::driver($driver);
				return true;
			}
		}

		return false;
	}

}

aslMloadExtensions();

if (!function_exists('aslMartSLFileAscSort')) {
/** Sort images in ascending order **/
function aslMartSLFileAscSort($a, $b) {
	list ($anum, $aalph) = explode ('.', $a);
	list ($bnum, $balph) = explode ('.', $b);
	
	if ($anum == $bnum) return strcmp($aalph, $balph);
	return $anum < $bnum ? -1 : 1;
}
}
if (!function_exists('aslMartSLFileDescSort')) {
/** Sort files in descending order **/
function aslMartSLFileDescSort($a, $b) {
	list ($anum, $aalph) = explode ('.', $a);
	list ($bnum, $balph) = explode ('.', $b);
	
	if ($anum == $bnum) return !strcmp($aalph, $balph);
	return $anum > $bnum ? -1 : 1;
}
}

$finalParams = array();
$finalParams['path'] = $params->get('path','');
$finalParams['thumbnailPath'] = $params->get('thumbnailPath','');
$finalParams['name'] = $params->get('name','SLB');
$finalParams['zIndex'] = $params->get('zIndex',65555);
$finalParams['color'] = $params->get('color','black');
$finalParams['find'] = $params->get('find','sexylightbox');
$finalParams['imagesdir'] = $params->get('imagesdir',JURI::BASE() . 'plugins/content/artsexylightbox/images');
$finalParams['background'] = $params->get('background','bgSexy.png');
$finalParams['backgroundIE'] = $params->get('backgroundIE','bgSexy.gif');
$finalParams['closeButton'] = $params->get('closeButton','SexyClose.png');
$finalParams['displayed'] = $params->get('displayed',0);
$finalParams['modal'] = $params->get('modal',0);
$finalParams['showDuration'] = $params->get('showDuration',200);
$finalParams['showEffect'] = $params->get('showEffect','linear');
$finalParams['closeDuration'] = $params->get('closeDuration',400);
$finalParams['closeEffect'] = $params->get('closeEffect','linear');
$finalParams['moveDuration'] = $params->get('moveDuration',800);
$finalParams['resizeDuration'] = $params->get('resizeDuration',800);
$finalParams['moveEffect'] = $params->get('moveEffect','easeOutBack');
$finalParams['resizeEffect'] = $params->get('resizeEffect','easeOutBack');
$finalParams['noConflict'] = $params->get('noConflict',false);
$finalParams['previewWidth'] = $params->get('previewWidth','');
$finalParams['previewHeight'] = $params->get('previewHeight','');
$finalParams['contentType'] = $params->get('contentType',1);
$finalParams['loadJQuery'] = $params->get('loadJQuery',1);
$finalParams['downloadLink'] = $params->get('downloadLink',0);
$finalParams['autoGenerateThumbs'] = $params->get('autoGenerateThumbs',0);
$finalParams['convertImageOption'] = $params->get('convertImageOption','resize');
$finalParams['arotate'] = $params->get('arotate','');
$finalParams['width1'] = $params->get('width1',500);
$finalParams['height1'] = $params->get('height1',500);

if ($finalParams['convertImageOption'] == 1) {
	$finalParams['convertImage'] = $finalParams['convertImageOption'];
} else if ($finalParams['arotate']){
	$finalParams['convertImage'] = 'rotate:' . $finalParams['arotate'];
}
$finalParams['imageDescriptions'] = $params->get('imageDescriptions','');

$finalParams['numberOfImages'] = $params->get('numberOfImages','');
$finalParams['caption'] = $params->get('caption',0);
$finalParams['galleryType'] = $params->get('galleryType','simple');
if ($finalParams['galleryType'] == 'carousel') {
	$finalParams['carousel'] = true;
} else if ($finalParams['galleryType'] == 'cloadCarousel') {
	$finalParams['cloudCarousel'] = true;
}
$finalParams['xPos'] = $params->get('xPos',285);
$finalParams['yPos'] = $params->get('yPos',120);
$finalParams['yRadius'] = $params->get('yRadius',40);
$finalParams['autoRotate'] = $params->get('autoRotate',false);
$finalParams['singleOption'] = $params->get('singleOption','full');
$finalParams['singleContent'] = $params->get('singleContent','');
if ($finalParams['singleOption'] == 'singleImage') {
	$finalParams['singleImage'] = $finalParams['singleContent'];
} else if ($finalParams['singleOption'] == 'singleText') {
	$finalParams['singleText'] = $finalParams['singleContent'];
}
$finalParams['showSingleImage'] = $params->get('showSingleImage', 1);
$finalParams['alt'] = $params->get('altTag','');
$finalParams['sort'] = $params->get('sort','asc');
$finalParams['carousel_visible'] = $params->get('carousel_visible',5);
$finalParams['carousel_scroll'] = $params->get('carousel_scroll',1);
$finalParams['containerHeight'] = $params->get('containerHeight','500px');
$finalParams['containerWidth'] = $params->get('containerWidth','500px');
$finalParams['flickr'] = $params->get('flickr','');
$finalParams['flickrUser'] = $params->get('flickrUser','');
if ($finalParams['flickrUser']) {
	$finalParams['flickr'] = $finalParams['flickrUser'];
}
$finalParams['flickrApiKey'] = $params->get('flickrApiKey','');
$finalParams['flickrSet'] = $params->get('flickrSet','');
$finalParams['flickrThumbSize'] = $params->get('flickrThumbSize','');
$finalParams['flickrImageSize'] = $params->get('flickrImageSize','');
$finalParams['picasaUser'] = $params->get('picasaUser','');
$finalParams['picasaAlbum'] = $params->get('picasaAlbum','');
$finalParams['photobucket'] = $params->get('photobucket','');
$acontent = $params->get('contentOption','');

$externalPage = $params->get('externalPage','');
$textOption1 = $params->get('textOption1','');
$singleImage1 = $params->get('singleImage1','');
$width2 = $params->get('width2', 500);
$height2 = $params->get('height2', 500);
$title1 = $params->get('title1','');


$finalParams['width'] = $params->get('width',300);
$finalParams['height'] = $params->get('height',100);
$finalParams['title'] = $params->get('title','');
$finalParams['text'] = $params->get('textOption','link');
$finalParams['singleImageOption'] = $params->get('singleImage','');
if ($finalParams['singleImageOption']) {
	$finalParams['singleImage'] = $finalParams['singleImageOption'];
}
$finalParams['remoteDirListing'] = $params->get('remoteDirListing','');
$finalParams['category'] = $params->get('category','');
$finalParams['section'] = $params->get('section','');

$finalParams['hideContent'] = $params->get('hideContent',1);
if ($finalParams['numberOfImages']) {
	$finalParams['flickrNumberOfImages'] = $finalParams['numberOfImages'];
}
if (!$finalParams['flickrNumberOfImages']) {
	$finalParams['flickrNumberOfImages'] = 20;
}

if (!isset ($finalParams['flickrThumbSize'])) {	
	$finalParams['flickrThumbSize'] = "s";
}

if (!isset ($finalParams['flickrImageSize'])) {
	$finalParams['flickrImageSize'] = "m";
	if (isset($finalParams['flickrApiKey'])) {
		$finalParams['flickrImageSize'] = '';
	}
}

if (!$finalParams['reflHeight']) {
	$finalParams['reflHeight'] = 56;
}
if (!$finalParams['reflGap']) {
	$finalParams['reflGap'] = 2;
}
if (!$finalParams['yRadius']) {
	$finalParams['yRadius'] = 40;
}
if (!$finalParams['xPos']) {
	$finalParams['xPos'] = 285;
}
if (!$finalParams['yPos']) {
	$finalParams['yPos'] = 120;
}
if (!$finalParams['titleBox']) {
	$finalParams['titleBox'] = '.cloud_carousel_title';
}
$finalParams['hideButtons'] = $params->get('hideButtons','');

if ($finalParams['contentType'] != 1) {
	$finalParams['path'] = '';
}
if ($finalParams['contentType'] != 2 && $finalParams['contentType'] != 3) {
	$finalParams['flickr'] = '';
	unset($finalParams['flickrApiKey']);
	unset($finalParams['flickrSet']);
}
if ($finalParams['contentType'] == 2) {
	unset($finalParams['flickrApiKey']);
	unset($finalParams['flickrSet']);
}

if ($finalParams['contentType'] != 4) {
	$finalParams['picasaUser'] = '';
	$finalParams['picasaAlbum'] = '';
}
if ($finalParams['contentType'] != 5) {
	$finalParams['photobucket'] = '';
}
if ($finalParams['contentType'] != 6) {
	$acontent = '';
}
if ($finalParams['contentType'] != 7) {
	$finalParams['remoteDirListing'] = '';
}
if ($finalParams['contentType'] != 8) {
	$finalParams['section'] = '';
	$finalParams['category'] = '';
}
		$color = $finalParams['color'];
		if (!$color) {
			$color = 'oldblack';
		}
		
		/** Dimensions **/
		$previewWidth = $finalParams['previewWidth'];
		$previewHeight = $finalParams['previewHeight'];
		$width = $finalParams['width'];
		$height = $finalParams['height'];
		
		/** Flickr parameters**/
		$flickr = $finalParams['flickr'];
		$flickrNumberOfImages = $finalParams['flickrNumberOfImages'];
		if (!$flickrNumberOfImages) {
			$flickrNumberOfImages = 20;
		}
		$flickrApiKey = $finalParams['flickrApiKey'];
		$flickrSet = $finalParams['flickrSet'];
		$flickrThumbSize = $finalParams['flickrThumbSize'];
		if (!isset ($flickrThumbSize)) {	
			$flickrThumbSize = "s";
		}
		$flickrImageSize = $finalParams['flickrImageSize'];
		if (!isset ($flickrImageSize)) {
			$flickrImageSize = "m";
			if (isset($flickrApiKey)) {
				$flickrImageSize = "";
			}
		}
		$flickrLargeImages = $finalParams['flickrLargeImages'];
		$flickrSmallThumbs = $finalParams['flickrSmallThumbs'];
		
		/** Picasa parameters**/
		$picasaUser = $finalParams['picasaUser'];
		$picasaAlbum = $finalParams['picasaAlbum'];
		
		/** Path **/
		$path = $finalParams['path'];
		$thumbnailPath = $finalParams['thumbnailPath'];
		$remoteDirListing = $finalParams['remoteDirListing'];
		
		/** Convert images **/
		$autoGenerateThumbs = $finalParams['autoGenerateThumbs'];
		$convertImage = $finalParams['convertImage'];
		if (!$convertImage) {
			$convertImage = 'resize';
		}
		
		/** Article parameters **/
		$section = $finalParams['section'];
		$category = $finalParams['category'];
		$articleContentOnly = $finalParams['articleContentOnly'];
		
		/** Carousel parameters **/
		$carousel = $finalParams['carousel'];
		$carousel_visible = $finalParams['carousel_visible'];
		if (!$carousel_visible) {
			$carousel_visible = 5;
		}
		$carousel_scroll = $finalParams['carousel_scroll'];
		if (!$carousel_scroll) {
			$carousel_scroll = 1;
		}
		
		/** Cloud carousel parameters **/
		$cloudCarousel = $finalParams['cloudCarousel'];
		$containerWidth = $finalParams['containerWidth'];
		if (!$containerWidth) {
			$containerWidth = '500px';
		}
		$containerHeight = $finalParams['containerHeight'];
		if (!$containerHeight) {
			$containerHeight = '500px';
		}
		if (!$finalParams['reflHeight']) {
			$finalParams['reflHeight'] = 56;
		}
		if (!$finalParams['reflGap']) {
			$finalParams['reflGap'] = 2;
		}
		if (!$finalParams['yRadius']) {
			$finalParams['yRadius'] = 40;
		}
		if (!$finalParams['xPos']) {
			$finalParams['xPos'] = 285;
		}
		if (!$finalParams['yPos']) {
			$finalParams['yPos'] = 120;
		}
		if (!$finalParams['titleBox']) {
			$finalParams['titleBox'] = '.cloud_carousel_title';
		}
		$hideButtons = $finalParams['hideButtons'];

		/** Inline parameters **/
		$width = $finalParams['width'];
		$height = $finalParams['height'];
		$background = $finalParams['background'];
		$modal = $finalParams['modal'];
		$text = $finalParams['text'];
		$title = $finalParams['title'];
		$hideContent = $finalParams['hideContent'];
		if (!$height) {
			$height = "100";
		}
		if (!$width) {
			$width = "300";
		}

		
		/** Other parameters **/
		$noConflict = $finalParams['noConflict'];
		$singleImage = $finalParams['singleImage'];
		$showSingleImage = $finalParams['showSingleImage'];
    if (!$showSingleImage) {
      $showSingleImage = 'false';
    }
		if ($finalParams['singleText']) {
			$finalParams['singleText'] = str_replace('[', '&#91;', $finalParams['singleText']);
			$finalParams['singleText'] = str_replace(']', '&#93;', $finalParams['singleText']);
		}
		$singleText = $finalParams['singleText'];
		$thumbnailPreviewCount = $finalParams['thumbnailPreviewCount'];
		$popup = $finalParams['popup'];
		$numberOfImages = $finalParams['numberOfImages'];
		$magnifier = $finalParams['magnifier'];
		$sort = $finalParams['sort'];
		$pAlt = $finalParams['alt'];
		$caption = $finalParams['caption'];
		$lang = $finalParams['lang'];
		
		$imagesCode = '<div class="artsexylightbox_container"';
		if ($cloudCarousel) {
			$imagesCode .= 'style="width:' . $containerWidth . ';height:' . $containerHeight . '" ';
		}
		$imagesCode .= '>';
		
		/** Add resources **/
		$document = &JFactory::getDocument();
		if ($cloudCarousel && $finalParams['loadJQuery']) {
			$document->addScript(JURI::root() . 'plugins/content/artsexylightbox/js/jquery.1.4.js');
		} else if ($finalParams['loadJQuery']){
			$document->addScript(JURI::root() . 'plugins/content/artsexylightbox/js/jquery.js');
		}
		$document->addScript(JURI::root() . 'plugins/content/artsexylightbox/js/jquery.easing.1.3.js');
		if ($carousel) {
			$document->addScript(JURI::root() . 'plugins/content/artsexylightbox/js/jcarousel.js');
		}
		if ($cloudCarousel) {
			$document->addScript(JURI::root() . 'plugins/content/artsexylightbox/js/cloud-carousel.js');
			$document->addStyleSheet(JURI::root() . 'plugins/content/artsexylightbox/css/cloudcarousel.css');
		}
		
		if ($color == 'white' || $color == 'black') {
			$document->addScript(JURI::root() . 'plugins/content/artsexylightbox/js/sexylightbox.v2.2.jquery.min.js');
			$document->addStyleSheet( JURI::root() . 'plugins/content/artsexylightbox/css/oldsexylightbox.css' );
		} else {
			if ($color == 'spanish_white') {
				$color = 'blanco';
				$finalParams['color'] = 'blanco';
			} else if ($color == 'spanish_black') {
				$color = 'negro';
				$finalParams['color'] = 'negro';
			}
			$document->addScript(JURI::root() . 'plugins/content/artsexylightbox/js/sexylightbox.v2.3.4.jquery.min.js');
			$document->addStyleSheet( JURI::root() . 'plugins/content/artsexylightbox/css/sexylightbox.css' );
		}
		$document->addScript(JURI::root() . 'plugins/content/artsexylightbox/js/jquery.flickr.js');
		$document->addScript(JURI::root() . 'plugins/content/artsexylightbox/js/jquery.nc.js');
		
		/** Begin inline javascript code **/
		$jsCode .= '<script type="text/javascript" charset="utf-8">asljQuery(function(){asljQuery(document).ready(function(){';
		
		/** ID for gallery **/
		$id = uniqid('artgallery_', false);
		
		if ($cloudCarousel && !$hideButtons) {
			$finalParams['buttonLeft'] = '#carousel_left' . $id;
			$finalParams['buttonRight'] = '#carousel_right' . $id;
		}
		
		/** Encode input parameters **/
		$imageDescrParam = $finalParams['imageDescriptions'];
		$finalParams['imageDescriptions'] = '';
		$jsonHandler = new ART_Services_JSON(SERVICES_JSON_LOOSE_TYPE);
		$dFP = !empty($finalParams) ? $jsonHandler->encode($finalParams) : '';
		
		/** Read images from remote server **/
		if ($remoteDirListing && $finalParams['contentType'] == 7) {
			$jsCode .= 'if (!window.sexylightboxEnabled) {SexyLightbox.initialize(' . $dFP . ');} if (!window.sexylightboxEnabled) {window.sexylightboxEnabled = true;}';
			ini_set('allow_url_fopen', 1);
			$file_handle = @fopen($remoteDirListing, "rb");
			if ($file_handle) {
				while (!feof($file_handle) ) {
					$line_of_text = fgets($file_handle);
				}
				fclose($file_handle);
			}
			$filelist = explode('<br />', $line_of_text);
			
			if ($singleImage) {
				$imagesCode .= "<a onclick='asljQuery(\"a[rel^=sexylightboxgallery]\").eq(0).click();return false;'><img alt='artsexylightbox_singleimage' class='artsexylightbox_singleimage' src='" . JURI::root() . $singleImage . "'";
				if ($previewHeight) {
					$imagesCode .= " height='$previewHeight'";
				}
				if ($previewWidth) {
					$imagesCode .= " width='$previewWidth' ";
				}
				$imagesCode .= " /></a>";
			}
			while (list ($key, $entry) = each ($filelist)) {
				if ($entry != '.' && $entry != '..' && $this->isImage($path . $entry)) {
					$imagesCode .= "<a href='$entry' rel='sexylightboxgallery[" . $id . "]' class='artsexylightboxpreview'>";
					if ($singleImage) {
						$imagesCode .= "</a>";
					} else {
									$imagesCode .= "<img alt='artsexylightbox' class='artsexylightbox' src='$entry' ";
									if ($previewHeight) {
											$imagesCode .= " height='$previewHeight' ";
									}
									if ($previewWidth) {
											$imagesCode .= "width='$previewWidth' ";
									}
									$imagesCode .= "/></a>";
								}
				}
			}
			$jsCode .= '})});</script>';
			$imagesCode .= '</div>';
			echo $imagesCode.$jsCode;
		
		/** Read images from local folder **/
		} else if ($path && $finalParams['contentType'] == 1) {
			if ($thumbnailPath) {
				$thumbs = array();
				$thumb_directory_stream = @ opendir (JPATH_SITE.DS . $thumbnailPath . DS);
				if ($thumb_directory_stream) {
					while ($entry = readdir ($thumb_directory_stream)) {
						if ($entry != '.' && $entry != '..' && aslMisImage($thumbnailPath . $entry)) {
							$thumbs[$entry] = $entry;
						}
					}
				}
			}
			/** Read image descriptions **/
			if ($lang && file_exists(JPATH_SITE . DS . $path . DS . 'artsexylightbox_' . $lang . '.txt')) {
				$file_handle = @fopen(JPATH_SITE . DS . $path . DS . 'artsexylightbox_' . $lang . '.txt', "rb");
			} else if (JRequest::getString('lang') && file_exists(JPATH_SITE . DS . $path . DS . 'artsexylightbox_' . JRequest::getString('lang') . '.txt')) {
				$file_handle = @fopen(JPATH_SITE . DS . $path . DS . 'artsexylightbox_' . JRequest::getString('lang') . '.txt', "rb");
			} else if ($this && $this->language && file_exists(JPATH_SITE . DS . $path . DS . 'artsexylightbox_' . $this->language . '.txt')) {
				$file_handle = @fopen(JPATH_SITE . DS . $path . DS . 'artsexylightbox_' . $this->language . '.txt', "rb");
			} else {
				$file_handle = @fopen(JPATH_SITE . DS . $path . DS . 'artsexylightbox.txt', 'rb');
			}
			$descriptionArray = array();
			if ($file_handle) {
				while (!feof($file_handle) ) {
					$line_of_text = fgets($file_handle);
					$parts = explode('=', htmlspecialchars($line_of_text, ENT_QUOTES));
					$str = '';
					$partsNumber = count($parts);
					for ($i = 1; $i < $partsNumber; $i++) {
						$str .= $parts[$i];
						if ($i != $partsNumber - 1) {
							$str .= '=';
						}
					}
					$str = str_replace('"', "'", $str);
					$descriptionArray[$parts[0]] = $str;
				}
				fclose($file_handle);
			}
			/*if ($imageDescrParam) {
				//echo $imageDescrParam;exit(0);
				$parts = explode('\n', $imageDescrParam);
				$str = '';
				$partsNumber = count($parts);
				for ($i = 1; $i < $partsNumber; $i++) {
					$str .= $parts[$i];
					if ($i != $partsNumber - 1) {
						$str .= '=';
					}
				}
				$str = str_replace('"', "'", $str);
				$descriptionArray[$parts[0]] = $str;
			}*/
			
			$jsCode .= 'if (!window.sexylightboxEnabled) {SexyLightbox.initialize(' . $dFP . ');} if (!window.sexylightboxEnabled) {window.sexylightboxEnabled = true;}';
			$directory_stream = @ opendir (JPATH_SITE.DS . $path . DS); 
			if (!$directory_stream) {
				echo "Could not open a directory stream for <i>" . JPATH_SITE . DS . $path . DS . "</i>";
			}
			$filelist = array();
			while ($entry = readdir ($directory_stream)) {
				if ($entry != '.' && $entry != '..' && aslMisImage($path . $entry)) {
					$filelist[] = $entry;
				}
			}
			/** Sort images **/
			if ($sort == 'desc') {
				usort ($filelist, 'aslMartSLFileDescSort');
			} else {
				usort ($filelist, 'aslMartSLFileAscSort');
			}
			if ($thumbnailPreviewCount && ($thumbnailPreviewCount > count($filelist))) {
				$thumbnailPreviewCount = count($filelist);
			}
			if ($singleImage) {
				if ($singleImage != 'random') {
					$imagesCode .= "<a onclick='asljQuery(\"a[rel*=" . $id . "]\").eq(0).click();return false;'><img alt='artsexylightbox' class='artsexylightbox_singleimage' src='" . JURI::root() . $singleImage . "'";
					if ($previewHeight) {
						$imagesCode .= " height='$previewHeight'";
					}
					if ($previewWidth) {
						$imagesCode .= " width='$previewWidth' ";
					}
					$imagesCode .= " /></a>";
				} else {
					mt_srand((double)microtime()*1000000);
					$rand = mt_rand(0, count($filelist) - 1);
					$imagesCode .= "<a onclick='asljQuery(\"a[rel*=" . $id . "]\").eq(0).click();return false;'><img alt='artsexylightbox' class='artsexylightbox_singleimage' src='" . JURI::root() . $path. '/' . $filelist[$rand] . "'";
					if ($previewHeight) {
						$imagesCode .= " height='$previewHeight'";
					}
					if ($previewWidth) {
						$imagesCode .= " width='$previewWidth' ";
					}
					$imagesCode .= " /></a>";
				}
			} else if ($singleText) {
				$imagesCode .= "<a onclick='asljQuery(\"a[rel*=" . $id . "]\").eq(0).click();return false;'><span class='artsexylightbox_singletext'>" . $singleText . "</span></a>";
			} else if ($thumbnailPreviewCount && $thumbnailPreviewCount > 0) {
				$thumbsCount = 0;
				while ((list ($key, $entry) = each ($filelist)) && ($thumbsCount < $thumbnailPreviewCount)) {
					if ($entry != '.' && $entry != '..' && aslMisImage($path . $entry)) {
						$imagePath = JPATH_SITE . DS . $path . DS . $entry;
						if ($thumbs && isset($thumbs[$entry])) {
							$imagesCode .= "<a onclick='asljQuery(\"a[rel*=" . $id . "]\").eq(0).click();return false;'><img alt='artsexylightbox' class='artsexylightbox_singleimage' src='" . JURI::root() . $thumbnailPath . '/' . $entry . "'";
						} else {
							$imagesCode .= "<a onclick='asljQuery(\"a[rel*=" . $id . "]\").eq(0).click();return false;'><img alt='artsexylightbox' class='artsexylightbox_singleimage' src='" . JURI::root() . $path . '/' . $entry . "'";
						}
						if ($previewHeight) {
							$imagesCode .= " height='$previewHeight'";
						}
						if ($previewWidth) {
							$imagesCode .= " width='$previewWidth' ";
						}
						$imagesCode .= " /></a>";
						$thumbsCount++;
					}
				}
			}
			reset ($filelist);
			$imagesCount = 0; 
			if ($singleImage) {
				$nfilelist = array();
				if ($showSingleImage != 'false') {
					if ($singleImage != 'random') {
						$nfilelist[] = $singleImage;
					} else {
						$nfilelist[] = $path. '/' .$filelist[$rand];
					}
				}
				while ((list ($key, $entry) = each ($filelist))) {
					if (($path . '/' . $entry) != $singleImage) {
						$nfilelist[] = $entry;
					}
				}
				reset ($nfilelist);
				$filelist = $nfilelist;
			}
			/** Show images as carousel **/
			if ($carousel && $path) {
				$imagesCode .= '<div class="asl_prev" id="aslcarouselprev_' . $id . '">&nbsp;</div><div class="asl_carousel" id="aslcarousel_' . $id . '"><ul>';
				while ((list ($key, $entry) = each ($filelist)) && ($numberOfImages > 0 ? ($imagesCount < $numberOfImages) : 1==1)) {
					if ($entry != '.' && $entry != '..' && aslMisImage($path . $entry)) {
						$title = '';
						if (isset($descriptionArray[$entry])) {
							$title = $descriptionArray[$entry];
						}
						$imagesCode .= "<li><a href='" . JURI::root() . "$path/$entry";
						$imagesCode .= "' rel='sexylightbox[" . $id . "]' class='artsexylightboxpreview' ";
						if ($title) {
							$imagesCode .= " title='" . $title . "'";
						}
						if ($singleImage) {
							$imagesCode .= " style='display:none;'></a>";
						} else {
							$imagesCode .= ">";
							if ($pAlt) {
								$alt = $pAlt;
							} else if ($title) {
								$alt = $title;
							} else if ($path) {
								$ind = strrpos($path, '/');
								$alt = substr($path, $ind);
							} else {
								$alt = 'artsexylightbox';
							}
							$imagesCode .= "<img alt='" . $alt . "' class='artsexylightbox' ";
							if ($thumbnailPreviewCount || $singleText) {
								$imagesCode .= " style='display:none;'";
							}
							$imagesCode .= " src='"; 
							$imagePath = JPATH_SITE . DS . $path . DS . $entry;
							if ($thumbs && isset($thumbs[$entry])) {
								$imagesCode .= JURI::root() . "$thumbnailPath/$entry' ";
							} else if (@is_readable($imagePath) && ($previewWidth > 0 || $previewHeight > 0 || strstr($convertImage, 'rotate')) && isset($autoGenerateThumbs) && $autoGenerateThumbs != 0) {
								if (!aslMisExtensionsLoaded()) {
									aslMloadExtensions();
								}
								if (!aslMisExtensionsLoaded()) {
									$imagesCode .= JURI::root() . "$path/$entry' ";
								} else {
									$imagePathInfo = pathinfo($imagePath);
									$generatedThumbName = sprintf('%s_%s_%s.%s',
										md5('artsexythumb_' . $convertImage . '_' . $imagePath),
										$previewWidth,
										$previewHeight,
										$imagePathInfo['extension']);
									if (!file_exists(JPATH_SITE . DS . 'images' . DS . 'artsexylightbox_tmp')) {
										mkdir (JPATH_SITE . DS . 'images' . DS . 'artsexylightbox_tmp');
									}
									$thumbPath = JPATH_SITE . DS . 'images' . DS . 'artsexylightbox_tmp' . DS . $generatedThumbName;
									
									if (!@file_exists($thumbPath)) {
										$img = asido::image($imagePath, $thumbPath);
										if ($convertImage == 'crop' && $previewWidth && $previewHeight) {
											Asido::crop($img, 0, 0, $previewWidth, $previewHeight);
										} else if ($convertImage == 'crop_resize' && $previewWidth && $previewHeight) {
											$imgSize = getimagesize($imagePath);
											$imgWidth = $imgSize[0];
											$imgHeight = $imgSize[1];
											if ($imgWidth > $imgHeight) {
												$diff = ($imgWidth - $imgHeight)/2;
												Asido::crop($img, $diff, 0, ($imgWidth - 2*$diff), $imgHeight);
											} else if ($imgWidth < $imgHeight) {
												$diff = ($imgHeight - $imgWidth)/2;
												Asido::crop($img, 0, $diff, $imgWidth, ($imgHeight - 2*$diff));
											}
											Asido::resize($img, $previewWidth, $previewHeight, ASIDO_RESIZE_STRETCH);
										} else if (strstr($convertImage, 'rotate')) {
											$rotateAttrs = explode(':', $convertImage);
											if (!$rotateAttrs[1]) {
												$rotateAttrs[1] = 90;
											}
											Asido::Rotate($img, $rotateAttrs[1]);
										} else {
											if (!$previewWidth) {
												Asido::height($img, $previewHeight);
											} else if (!$previewHeight) {
												Asido::width($img, $previewWidth);
											} else {
												Asido::resize($img, $previewWidth, $previewHeight, ASIDO_RESIZE_STRETCH);
											}
										}
										$img->save(ASIDO_OVERWRITE_ENABLED);
									}
									$imagesCode .= JURI::root() . "images/artsexylightbox_tmp/$generatedThumbName' ";
								}
							} else {
								$imagesCode .= JURI::root() . "$path/$entry' ";
							}
							if ($previewHeight) {
								$imagesCode .= " height='$previewHeight' ";
							}
							if ($previewWidth) {
								$imagesCode .= "width='$previewWidth' ";
							}
							$imagesCode .= "/></a></li>";
						}
					}
					$imagesCount++;
				}
				$imagesCode .= '</ul></div><div id="aslcarouselnext_' . $id . '" class="asl_next">&nbsp;</div>';
				$jsCode .= '})});asljQuery(function() {asljQuery("#aslcarousel_' . $id . '").jCarouselLite({circular: false, visible: ' . $carousel_visible . ', scroll: ' . $carousel_scroll . ', btnNext: "#aslcarouselnext_' . $id . '", btnPrev: "#aslcarouselprev_' . $id . '"});});</script>';
				$imagesCode .= '</div>';
				if (isset($popup) && $popup == 'false') {
					$jsCode = '<script type="text/javascript" charset="utf-8">asljQuery(function() {asljQuery("#aslcarousel_' . $id . '").jCarouselLite({circular: false, visible: ' . $carousel_visible . ', scroll: ' . $carousel_scroll . ', btnNext: "#aslcarouselnext_' . $id . '", btnPrev: "#aslcarouselprev_' . $id . '"});});</script>';
					echo $imagesCode.$jsCode;
				}
				echo $imagesCode.$jsCode;
			} else if ($cloudCarousel) {
				/** Show gallery from local folder **/
				$o = 0;
				while ((list ($key, $entry) = each ($filelist)) && ($numberOfImages > 0 ? ($imagesCount < $numberOfImages) : 1==1)) {
					if ($entry != '.' && $entry != '..' && aslMisImage($path . $entry)) {
						$title = '';
						if (isset($descriptionArray[$entry])) {
							$title = $descriptionArray[$entry];
						}
						if ($caption) {
							$imagesCode .= "<div class='asl_image_caption'>";
						}
						if ($singleImage && $o == 0 && $showSingleImage != 'false') {
							$ind1 = strrpos($singleImage, '/');
							$sI = substr($singleImage, $ind1 + 1);
							if (isset($descriptionArray[$sI])) {
								$title = $descriptionArray[$sI];
							}
							$imagesCode .= "<a href='" . JURI::root() . "$entry";
							$imagesCode .= "' rel='sexylightbox[" . $id . "]' class='artsexylightboxpreview' ";
						} else {
							$imagesCode .= "<a href='" . JURI::root() . "$path/$entry";
							$imagesCode .= "' rel='sexylightbox[" . $id . "]' class='artsexylightboxpreview' ";
						}
						$o++;
						if ($title) {
							$imagesCode .= " title='" . $title . "'";
						}
						if ($singleImage) {
								$imagesCode .= " style='display:none;'></a>";
						} else {
							$imagesCode .= ">";
							if ($pAlt) {
								$alt = $pAlt;
							} else if ($title) {
								$alt = $title;
							} else if ($path) {
								$ind = strrpos($path, '/');
								$alt = substr($path, $ind + 1);
							} else {
								$alt = 'artsexylightbox';
							}
							$imagesCode .= "<img alt='" . $alt . "' class='artsexylightbox cloudcarousel' ";
							if ($title) {
								$imagesCode .= " title='" . $title . "'";
							}
							if ($thumbnailPreviewCount || $singleText) {
								$imagesCode .= " style='display:none;'";
							}
							$imagesCode .= " src='"; 
							$imagePath = JPATH_SITE . DS . $path . DS . $entry;
							if ($thumbs && isset($thumbs[$entry])) {
								$imagesCode .= JURI::root() . "$thumbnailPath/$entry";
								$imagesCode .= "' ";
							} else if (@is_readable($imagePath) && ($previewWidth > 0 || $previewHeight > 0 || strstr($convertImage, 'rotate')) && isset($autoGenerateThumbs) && $autoGenerateThumbs != 0) {
								if (!aslMisExtensionsLoaded()) {
									aslMloadExtensions();
								}
								if (!aslMisExtensionsLoaded()) {
									$imagesCode .= JURI::root() . "$path/$entry' ";
								} else {
									$imagePathInfo = pathinfo($imagePath);
									$generatedThumbName = sprintf('%s_%s_%s.%s',
										md5('artsexythumb_' . $convertImage . '_' . $imagePath),
										$previewWidth,
										$previewHeight,
										$imagePathInfo['extension']);
									if (!file_exists(JPATH_SITE . DS . 'images' . DS . 'artsexylightbox_tmp')) {
										mkdir (JPATH_SITE . DS . 'images' . DS . 'artsexylightbox_tmp');
									}
									$thumbPath = JPATH_SITE . DS . 'images' . DS . 'artsexylightbox_tmp' . DS . $generatedThumbName;
									
									if (!@file_exists($thumbPath)) {
										$img = asido::image($imagePath, $thumbPath);
										if ($convertImage == 'crop' && $previewWidth && $previewHeight) {
											Asido::crop($img, 0, 0, $previewWidth, $previewHeight);
										} else if ($convertImage == 'crop_resize' && $previewWidth && $previewHeight) {
											$imgSize = getimagesize($imagePath);
											$imgWidth = $imgSize[0];
											$imgHeight = $imgSize[1];
											if ($imgWidth > $imgHeight) {
												$diff = ($imgWidth - $imgHeight)/2;
												Asido::crop($img, $diff, 0, ($imgWidth - 2*$diff), $imgHeight);
											} else if ($imgWidth < $imgHeight) {
												$diff = ($imgHeight - $imgWidth)/2;
												Asido::crop($img, 0, $diff, $imgWidth, ($imgHeight - 2*$diff));
											}
											Asido::resize($img, $previewWidth, $previewHeight, ASIDO_RESIZE_STRETCH);
										} else if (strstr($convertImage, 'rotate')) {
											$rotateAttrs = explode(':', $convertImage);
											if (!$rotateAttrs[1]) {
												$rotateAttrs[1] = 90;
											}
											Asido::Rotate($img, $rotateAttrs[1]);
										} else {
											if (!$previewWidth) {
												Asido::height($img, $previewHeight);
											} else if (!$previewHeight) {
												Asido::width($img, $previewWidth);
											} else {
												Asido::resize($img, $previewWidth, $previewHeight, ASIDO_RESIZE_STRETCH);
											}
										}
										$img->save(ASIDO_OVERWRITE_ENABLED);
									}
									$imagesCode .= JURI::root() . "images/artsexylightbox_tmp/$generatedThumbName' ";
								}
							} else {
								$imagesCode .= JURI::root() . "$path/$entry' ";
							}
							if ($previewHeight) {
								$imagesCode .= " height='$previewHeight' ";
							}
							if ($previewWidth) {
								$imagesCode .= "width='$previewWidth' ";
							}
							$imagesCode .= "/></a>";
							if ($caption) {
								$title = str_replace('&lt;', '<', $title);
								$title = str_replace('&gt;', '>', $title);
								$imagesCode .= '<div class="asl_caption">' . html_entity_decode($title) . '</div>';
								$imagesCode .= '</div>';
							}
						}
					}
					$imagesCount++;
				}
				if (isset($popup) && $popup == 'false') {
					echo $imagesCode;
				}
				$jsCode .= 'asljQuery(".artsexylightbox_container").CloudCarousel(' . $dFP . ');})});</script>';
				$imagesCode .= '<div class="cloud_carousel_title"></div>';
				if (!$hideButtons) {
					$imagesCode .= '<div id="carousel_left' . $id . '" class="carouselLeft"></div>';
					$imagesCode .= '<div id="carousel_right' . $id . '" class="carouselRight"></div>';
				}
				$imagesCode .= '</div>';
				echo $imagesCode.$jsCode;
			} else {
				/** Show gallery from local folder **/
				$o = 0;
				while ((list ($key, $entry) = each ($filelist)) && ($numberOfImages > 0 ? ($imagesCount < $numberOfImages) : 1==1)) {
					if ($entry != '.' && $entry != '..' && aslMisImage($path . $entry)) {
						$title = '';
						if (isset($descriptionArray[$entry])) {
							$title = $descriptionArray[$entry];
						}
						if ($caption) {
							$imagesCode .= "<div class='asl_image_caption'>";
						}
						if ($singleImage && $o == 0 && $showSingleImage != 'false') {
							$ind1 = strrpos($singleImage, '/');
							$sI = substr($singleImage, $ind1 + 1);
							if (isset($descriptionArray[$sI])) {
								$title = $descriptionArray[$sI];
							}
							$imagesCode .= "<a href='" . JURI::root() . "$entry";
							$imagesCode .= "' rel='sexylightbox[" . $id . "]' class='artsexylightboxpreview' ";
						} else {
							$imagesCode .= "<a href='" . JURI::root() . "$path/$entry";
							$imagesCode .= "' rel='sexylightbox[" . $id . "]' class='artsexylightboxpreview' ";
						}
						$o++;
						if ($title) {
							$imagesCode .= " title='" . $title . "'";
						}
						if ($singleImage) {
								$imagesCode .= " style='display:none;'></a>";
						} else {
							$imagesCode .= ">";
							if ($pAlt) {
								$alt = $pAlt;
							} else if ($title) {
								$alt = $title;
							} else if ($path) {
								$ind = strrpos($path, '/');
								$alt = substr($path, $ind + 1);
							} else {
								$alt = 'artsexylightbox';
							}
							$imagesCode .= "<img alt='" . $alt . "' class='artsexylightbox' ";
							if ($thumbnailPreviewCount || $singleText) {
								$imagesCode .= " style='display:none;'";
							}
							$imagesCode .= " src='"; 
							$imagePath = JPATH_SITE . DS . $path . DS . $entry;
							if ($thumbs && isset($thumbs[$entry])) {
								$imagesCode .= JURI::root() . "$thumbnailPath/$entry";
								$imagesCode .= "' ";
							} else if (@is_readable($imagePath) && ($previewWidth > 0 || $previewHeight > 0 || strstr($convertImage, 'rotate')) && isset($autoGenerateThumbs) && $autoGenerateThumbs != 0) {
								if (!aslMisExtensionsLoaded()) {
									aslMloadExtensions();
								}
								if (!aslMisExtensionsLoaded()) {
									$imagesCode .= JURI::root() . "$path/$entry' ";
								} else {
									$imagePathInfo = pathinfo($imagePath);
									$generatedThumbName = sprintf('%s_%s_%s.%s',
										md5('artsexythumb_' . $convertImage . '_' . $imagePath),
										$previewWidth,
										$previewHeight,
										$imagePathInfo['extension']);
									if (!file_exists(JPATH_SITE . DS . 'images' . DS . 'artsexylightbox_tmp')) {
										mkdir (JPATH_SITE . DS . 'images' . DS . 'artsexylightbox_tmp');
									}
									$thumbPath = JPATH_SITE . DS . 'images' . DS . 'artsexylightbox_tmp' . DS . $generatedThumbName;
									
									if (!@file_exists($thumbPath)) {
										$img = asido::image($imagePath, $thumbPath);
										if ($convertImage == 'crop' && $previewWidth && $previewHeight) {
											Asido::crop($img, 0, 0, $previewWidth, $previewHeight);
										} else if ($convertImage == 'crop_resize' && $previewWidth && $previewHeight) {
											$imgSize = getimagesize($imagePath);
											$imgWidth = $imgSize[0];
											$imgHeight = $imgSize[1];
											if ($imgWidth > $imgHeight) {
												$diff = ($imgWidth - $imgHeight)/2;
												Asido::crop($img, $diff, 0, ($imgWidth - 2*$diff), $imgHeight);
											} else if ($imgWidth < $imgHeight) {
												$diff = ($imgHeight - $imgWidth)/2;
												Asido::crop($img, 0, $diff, $imgWidth, ($imgHeight - 2*$diff));
											}
											Asido::resize($img, $previewWidth, $previewHeight, ASIDO_RESIZE_STRETCH);
										} else if (strstr($convertImage, 'rotate')) {
											$rotateAttrs = explode(':', $convertImage);
											if (!$rotateAttrs[1]) {
												$rotateAttrs[1] = 90;
											}
											Asido::Rotate($img, $rotateAttrs[1]);
										} else {
											if (!$previewWidth) {
												Asido::height($img, $previewHeight);
											} else if (!$previewHeight) {
												Asido::width($img, $previewWidth);
											} else {
												Asido::resize($img, $previewWidth, $previewHeight, ASIDO_RESIZE_STRETCH);
											}
										}
										$img->save(ASIDO_OVERWRITE_ENABLED);
									}
									$imagesCode .= JURI::root() . "images/artsexylightbox_tmp/$generatedThumbName' ";
								}
							} else {
								$imagesCode .= JURI::root() . "$path/$entry' ";
							}
							if ($previewHeight) {
								$imagesCode .= " height='$previewHeight' ";
							}
							if ($previewWidth) {
								$imagesCode .= "width='$previewWidth' ";
							}
							$imagesCode .= "/></a>";
							if ($caption) {
								$title = str_replace('&lt;', '<', $title);
								$title = str_replace('&gt;', '>', $title);
								$imagesCode .= '<div class="asl_caption">' . html_entity_decode($title) . '</div>';
								$imagesCode .= '</div>';
							}
						}
					}
					$imagesCount++;
				}
				if (isset($popup) && $popup == 'false') {
					echo $imagesCode;
				}
				$jsCode .= '})});</script>';
				$imagesCode .= '</div>';
				echo $imagesCode.$jsCode;
			}
		/** Show Flickr images **/
		} else if ($flickr && ($finalParams['contentType'] == 2 || $finalParams['contentType'] == 3)) {
			if (!$singleImage) {
				$singleImage = false;
			}
			/** Show Flickr photo set **/
			//echo $flickrApiKey;exit(0);
			if (isset($flickrApiKey) && isset($flickrSet) && $flickrApiKey !== '' && $flickrSet !== '') {
				$imagesCode .= "<div id='$id' class='artflickrgallery'></div>";
				$jsCode .= 'asljQuery("#' . $id . '").flickr({singleImage: "' . $singleImage . '", find: "' . $id . '", thumb_size:"' . $flickrThumbSize . '",size:"' . $flickrImageSize . '",per_page:' . $flickrNumberOfImages . ',api_key:"' . $flickrApiKey . '",photoset_id:"' . $flickrSet . '", user_id: "' . $flickr . '", type: "photoset",callback: function(el) {SexyLightbox.initialize(' . $dFP . ');}});';
			/** Show Flickr photo feed **/
			} else {
				$jsCode .= 'if (!window.sexylightboxEnabled) {SexyLightbox.initialize(' . $dFP . ');} if (!window.sexylightboxEnabled) {window.sexylightboxEnabled = true;}';
				if (strstr($flickr, ',')) {
					$ids = explode(',', $flickr);
				} else {
					$id = $flickr;
				}
				if ($id) {
					$url = 'http://api.flickr.com/services/feeds/photos_public.gne?format=php_serial&id=' . $id;
				} else {
					$url = 'http://api.flickr.com/services/feeds/photos_public.gne?format=php_serial&ids=' . $ids;
				}
				ini_set('allow_url_fopen', 1);
				if ($fp = fopen($url, 'r')) {
					 $acontent = '';
					 while ($line = fread($fp, 1024)) {
						$acontent .= $line;
					 }
				} else {
					$ch = curl_init();
								curl_setopt($ch, CURLOPT_URL, $url);
								curl_setopt($ch, CURLOPT_HEADER, 0);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
								$acontent = curl_exec($ch);
				}
				if ($acontent) {
					 $rsp_obj = unserialize($acontent);
					 
					 $i = 1;
					 
					 if ($singleImage && $singleImage !== 'true') {
						$imagesCode .= "<a href='" . substr($singleImage, 0, -6) . ".jpg' rel='sexylightbox[" . $id . "]' class='artsexylightboxpreview' ";
						$imagesCode .= "><img alt='artsexylightbox' class='artsexylightbox' src='" . $singleImage . "'";
						if ($previewHeight) {
							$imagesCode .= " height='$previewHeight' ";
						}
						if ($previewWidth) {
							$imagesCode .= "width='$previewWidth' ";
						}
						$imagesCode .= "/></a>";
					}

					 foreach ($rsp_obj['items'] as $image) {
						if ($i > $flickrNumberOfImages) {
							break;
						}
						$title = htmlspecialchars($image['title'], ENT_QUOTES);
						$largeImagePath = $image['m_url'];
						$smallThumbPath = $image['m_url'];
						if ($flickrLargeImages) {
							$largeImagePath = $image['l_url'];
						}
						if ($flickrSmallThumbs) {
							$smallThumbPath = $image['t_url'];
						}
						
						$imagesCode .= "<a href='" . $largeImagePath . "' rel='sexylightbox[" . $id . "]' class='artsexylightboxpreview' ";
						if ($title) {
							$imagesCode .= "title='" . $title . "'";
						}
						if ($singleImage) {
							$imagesCode .= " style='display:none;'";
						}
						$imagesCode .= "><img alt='artsexylightbox' class='artsexylightbox' src='" . $smallThumbPath . "'";
						if ($previewHeight) {
							$imagesCode .= " height='$previewHeight' ";
						}
						if ($previewWidth) {
							$imagesCode .= "width='$previewWidth' ";
						}
						$imagesCode .= "/></a>";
						$i++;
					}		 
				}
			}
			$imagesCode .= '</div>';
			if (isset($popup) && $popup == 'false') {
				echo $imagesCode;
			}
			$jsCode .= '})});</script>';
			echo $imagesCode.$jsCode;
		/** Show picasa photos **/
		} else if ($picasaUser && $picasaAlbum && $finalParams['contentType'] == 4) {
			if ($carousel) {
				$jsCode .= 'if (!window.sexylightboxEnabled) {SexyLightbox.initialize(' . $dFP . ');} if (!window.sexylightboxEnabled) {window.sexylightboxEnabled = true;}';
				$imagesCode .= '<div class="asl_prev" id="aslcarouselprev_' . $id . '">&nbsp;</div><div class="asl_carousel" id="aslcarousel_' . $id . '"><ul>';
				$feedURL = "http://picasaweb.google.com/data/feed/api/user/$picasaUser/album/$picasaAlbum";
				ini_set('allow_url_fopen', 1);
				$sxml = simplexml_load_file($feedURL);
				if (!$sxml) {
					$string= file_get_contents($feedURL);
					$ch = curl_init();
					curl_setopt($ch, CURLOPT_URL, $feedURL);
					curl_setopt($ch, CURLOPT_HEADER, 0);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					$acontent = curl_exec($ch);
					$sxml = simplexml_load_string($acontent);
				}
				$counts = $sxml->children('http://a9.com/-/spec/opensearchrss/1.0/');
				$total = $counts->totalResults;
				$k = 0;
				$i = 1;
				foreach ($sxml->entry as $entry) {
					if ( ($numberOfImages && $numberOfImages > 0) && $i > $numberOfImages) {
						break;
					}
					$summary = $entry->summary;
					$title = $summary;

					$gphoto = $entry->children('http://schemas.google.com/photos/2007');
					
					$size = $gphoto->size;
					$height = $gphoto->height;
					$width = $gphoto->width;

					$media = $entry->children('http://search.yahoo.com/mrss/');
					$thumbnail = $media->group->thumbnail[1];
					
					$pContent = $entry->content;
					
					$tags = $media->group->keywords;
					
					$attr = $pContent->attributes();
					$tattr = $thumbnail->attributes();
					$imagesCode .= "<li><a href='" . $attr->{'src'} . "' rel='sexylightbox[" . $id . "]' class='artsexylightboxpreview' ";
					if ($title) {
						$imagesCode .= "title='" . $title . "'";
					}
					if ($singleImage && $k != 0) {
						$imagesCode .= " style='display:none;'";
					}
					$imagesCode .= "><img alt='$title' class='artsexylightbox' src='" . $tattr->{'url'} . "'";
					if ($previewHeight) {
						$imagesCode .= " height='$previewHeight' ";
					}
					if ($previewWidth) {
						$imagesCode .= "width='$previewWidth' ";
					}
					$imagesCode .= "/></a>";
					$k++;
					$i++;
				}
				$imagesCode .= '</ul></div><div id="aslcarouselnext_' . $id . '" class="asl_next">&nbsp;</div>';
				$jsCode .= '})});asljQuery(function() {asljQuery("#aslcarousel_' . $id . '").jCarouselLite({circular: false, visible: ' . $carousel_visible . ', scroll: ' . $carousel_scroll . ', btnNext: "#aslcarouselnext_' . $id . '", btnPrev: "#aslcarouselprev_' . $id . '"});});</script>';
				$imagesCode .= '</div>';
				if (isset($popup) && $popup == 'false') {
					$jsCode = '<script type="text/javascript" charset="utf-8">asljQuery(function() {asljQuery("#aslcarousel_' . $id . '").jCarouselLite({circular: false, visible: ' . $carousel_visible . ', scroll: ' . $carousel_scroll . ', btnNext: "#aslcarouselnext_' . $id . '", btnPrev: "#aslcarouselprev_' . $id . '"});});</script>';
					echo $imagesCode.$jsCode;
				}
				echo $imagesCode.$jsCode;
			} else {
				$jsCode .= 'if (!window.sexylightboxEnabled) {SexyLightbox.initialize(' . $dFP . ');} if (!window.sexylightboxEnabled) {window.sexylightboxEnabled = true;}';
				$feedURL = "http://picasaweb.google.com/data/feed/api/user/$picasaUser/album/$picasaAlbum";
				ini_set('allow_url_fopen', 1);
				$sxml = simplexml_load_file($feedURL);
				if (!$sxml) {
					$string= file_get_contents($feedURL);
					$ch = curl_init();
					curl_setopt($ch, CURLOPT_URL, $feedURL);
					curl_setopt($ch, CURLOPT_HEADER, 0);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					$acontent = curl_exec($ch);
					$sxml = simplexml_load_string($acontent);
				}
				$counts = $sxml->children('http://a9.com/-/spec/opensearchrss/1.0/');
				$total = $counts->totalResults;
				$k = 0;
				$i = 1;
				foreach ($sxml->entry as $entry) {
					if ( ($numberOfImages && $numberOfImages > 0) && $i > $numberOfImages) {
						break;
					}
					$summary = $entry->summary;
					$title = $summary;

					$gphoto = $entry->children('http://schemas.google.com/photos/2007');
					
					$size = $gphoto->size;
					$height = $gphoto->height;
					$width = $gphoto->width;

					$media = $entry->children('http://search.yahoo.com/mrss/');
					$thumbnail = $media->group->thumbnail[1];
					
					$pContent = $entry->content;
					
					$tags = $media->group->keywords;
					
					$attr = $pContent->attributes();
					$tattr = $thumbnail->attributes();
					if ($caption) {
						$imagesCode .= "<div class='asl_image_caption'>";
					}
					$imagesCode .= "<a href='" . $attr->{'src'} . "' rel='sexylightbox[" . $id . "]' class='artsexylightboxpreview' ";
					if ($title) {
						$imagesCode .= "title='" . $title . "'";
					}
					if ($singleImage && $k != 0) {
						$imagesCode .= " style='display:none;'";
					}
					$imagesCode .= "><img alt='$title' class='artsexylightbox' src='" . $tattr->{'url'} . "'";
					if ($previewHeight) {
						$imagesCode .= " height='$previewHeight' ";
					}
					if ($previewWidth) {
						$imagesCode .= "width='$previewWidth' ";
					}
					$imagesCode .= "/></a>";
					if ($caption) {
						$title = str_replace('&lt;', '<', $title);
						$title = str_replace('&gt;', '>', $title);
						$imagesCode .= '<div class="asl_caption">' . html_entity_decode($title) . '</div>';
						$imagesCode .= '</div>';
					}
					$k++;
					$i++;
				}
				$imagesCode .= '</div>';
				if (isset($popup) && $popup == 'false') {
					echo $imagesCode;
				}
				$jsCode .= '})});</script>';
				echo $imagesCode.$jsCode;
			}
		/** Show Photobucket album **/
		} else if ($finalParams['contentType'] == 4 && $finalParams['photobucket']) {
			$jsCode .= 'if (!window.sexylightboxEnabled) {SexyLightbox.initialize(' . $dFP . ');} if (!window.sexylightboxEnabled) {window.sexylightboxEnabled = true;}';
			$feedURL = $photobucket;
			ini_set('allow_url_fopen', 1);
			$sxml = simplexml_load_file($feedURL);
			if (!$sxml) {
				$string= file_get_contents($feedURL);
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $feedURL);
				curl_setopt($ch, CURLOPT_HEADER, 0);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				$content = curl_exec($ch);
				$sxml = simplexml_load_string($content);
			}
			if (!$sxml || !$sxml->channel) {
				$imagesCode = 'Photobucket user or album is not correct';
			} else {
				$k = 0;
				$i = 1;
				foreach ($sxml->channel->item as $entry) {
					if ( ($numberOfImages && $numberOfImages > 0) && $i > $numberOfImages) {
						break;
					}
					$media = $entry->children('http://search.yahoo.com/mrss/');
					$media2 = $media->content->children('http://search.yahoo.com/mrss/');
					$media3 = $media->content->attributes();
					$imgLink = $media3->{'url'};
						
					$attrs = $media2->thumbnail->attributes();
					$title = $entry->title;
					$thumbnail = $attrs->{'url'};
							
					if ($caption) {
						$imagesCode .= "<div class='asl_image_caption'>";
					}
					$imagesCode .= "<a href='" . $imgLink . "' rel='sexylightbox[" . $id . "]' class='artsexylightboxpreview' ";
					if ($title) {
						$imagesCode .= "title='" . $title . "'";
					}
					if ($singleImage && $k != 0) {
						$imagesCode .= " style='display:none;'";
					}
					$imagesCode .= "><img alt='$title' class='artsexylightbox' src='" . $thumbnail . "'";
					if ($previewHeight) {
						$imagesCode .= " height='$previewHeight' ";
					}
					if ($previewWidth) {
						$imagesCode .= "width='$previewWidth' ";
					}
					$imagesCode .= "/></a>";
					if ($caption) {
						$title = str_replace('&lt;', '<', $title);
						$title = str_replace('&gt;', '>', $title);
						$imagesCode .= '<div class="asl_caption">' . html_entity_decode($title) . '</div>';
						$imagesCode .= '</div>';
					}
					$k++;
					$i++;
				}
			}
			$imagesCode .= '</div>';
			if (isset($popup) && $popup == 'false') {
				return $imagesCode;
			}
			$jsCode .= '})});</script>';
			return $imagesCode.$jsCode;
		/** Show article links **/
		} else if (($section || $category) && $finalParams['contentType'] == 8) {
			$section = mysql_real_escape_string($section);
			$category = mysql_real_escape_string($category);
			$jsCode .= 'if (!window.sexylightboxEnabled) {SexyLightbox.initialize(' . $dFP . ');} if (!window.sexylightboxEnabled) {window.sexylightboxEnabled = true;}';
			$db	=& JFactory::getDBO();
			$query = 'SELECT * FROM #__content ';
			if (isset($section) && $section && isset($category) && $category) {
				$query .= 'WHERE sectionid = ' . $section;
				$query .= ' AND catid = ' . $category;
			} else {
				if (isset($section) && $section) {
					$query .= 'WHERE sectionid = ' . $section;
				}
				if (isset($category) && $category) {
					$query .= 'WHERE catid = ' . $category;
				}
			}
			
			$db->setQuery($query);
			$rows = $db->loadObjectList();
			if (!$finalPatams['width1']) {
				$previewWidth = '500';
			}
			if (!$finalPatams['height1']) {
				$previewHeight = '500';
			}
			foreach ($rows as $row) {
				$title = $row->title;
				$uri = JFactory::getURI();
				if ($articleContentOnly) {
					$url = $uri->root().'index.php?option=com_content&tmpl=component&id='.$row->id;
				} else {
					$url = $uri->root().'index.php?option=com_content&view=article&id='.$row->id;
				}
				if (isset($category) && $category) {
					$url .= '&catid=' . $category;
				}
				$url .= '&TB_iframe=true&';
				$url .= 'width=' . $previewWidth;
				$url .= '&height=' . $previewHeight;
				$imagesCode .= "<a href='$url' rel='sexylightboxgallery[" . $id . "]' class='artsexylightboxlink' title='$title'>";
				$imagesCode .= $title;
				$imagesCode .= "</a>";
			}
			$jsCode .= '})});</script>';
			$imagesCode .= "</div>";
			echo $imagesCode.$jsCode;
		/** Show inline content **/
		} else if (isset($acontent) && !empty($acontent) && $finalParams['contentType'] == 6) {
			$id = uniqid('artinline_', false);
			$url = "#TB_inline?inlineId=$id";
			if (isset($height) && !empty($height)) $url .= "&height=$height";
			if (isset($width) && !empty($width)) $url .= "&width=$width";
			if (isset($modal) && !empty($modal)) $url .= "&modal=$modal";
			if ($singleImage) {
				$text = "<img alt='artsexylightbox_singleimage' class='artsexylightbox_singleimage' src='". $singleImage ."'";
				if ($previewHeight) {
					$text .= " height='$previewHeight' ";
				}
				if ($previewWidth) {
					$text .= "width='$previewWidth' ";
				}
				$text .= "/>";
			} else if ($singleText) {
				$text = $singleText;
			}
			$inlineCode = "<span id='$id'>" . $acontent . "</span><a href='$url' rel='sexylightbox' title='$title'>$text</a>";
			$jsCode .= 'SexyLightbox.initialize(' . $dFP . ');';
			if ($hideContent) {
				$jsCode .= 'document.getElementById("' . $id . '").style.display = "none";';
			}
			$jsCode .= 'if (!window.sexylightboxEnabled) {window.sexylightboxEnabled = true;}';
			$jsCode .= '})});</script>';
			echo $jsCode.$inlineCode;
		} else if (isset($externalPage) && $finalParams['contentType'] == 9) {
      $id = uniqid('artiframe_', false);
			$url = $externalPage . "?TB_iframe=true";
			if (isset($height2) && !empty($height2)) $url .= "&height=$height2";
			if (isset($width2) && !empty($width2)) $url .= "&width=$width2";
			if (isset($modal) && !empty($modal)) $url .= "&modal=$modal";
				$text = "<img alt='artsexylightbox_singleimage' class='artsexylightbox_singleimage' src='". $singleImage1 ."'";
			if ($singleImage1) {
				if ($previewHeight) {
					$text .= " height='$previewHeight' ";
				}
				if ($previewWidth) {
					$text .= "width='$previewWidth' ";
				}
				$text .= "/>";
			} else if ($textOption1) {
				$text = $textOption1;
			}
			$inlineCode = "<span id='$id'>" . $acontent . "</span><a href='$url' rel='sexylightbox' title='$title1'>$text</a>";
			$jsCode .= 'SexyLightbox.initialize(' . $dFP . ');';
			$jsCode .= 'if (!window.sexylightboxEnabled) {window.sexylightboxEnabled = true;}';
			$jsCode .= '})});</script>';
			echo $jsCode.$inlineCode;
    } else {
			$jsCode .= 'if (!window.sexylightboxEnabled) {SexyLightbox.initialize(' . $dFP . ')};if (!window.sexylightboxEnabled) {window.sexylightboxEnabled = true;}';
			$jsCode .= '})});</script>';
			echo $jsCode;
		}	

?>